/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.inventory.personalstorage;

import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageData;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageItemInventory;
import fr.iglee42.evolvedmekanism.items.ItemBlockTieredPersonalStorage;
import fr.iglee42.evolvedmekanism.tiers.PersonalStorageTier;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import mekanism.api.AutomationType;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class TieredPersonalStorageManager {
    private static final Map<UUID, TieredPersonalStorageData> STORAGE_BY_PLAYER_UUID = new HashMap<UUID, TieredPersonalStorageData>();

    private static TieredPersonalStorageData forOwner(UUID playerUUID) {
        return STORAGE_BY_PLAYER_UUID.computeIfAbsent(playerUUID, uuid -> (TieredPersonalStorageData)MekanismSavedData.createSavedData(TieredPersonalStorageData::new, (String)("tiered_personal_storage" + File.separator + String.valueOf(uuid))));
    }

    public static TieredPersonalStorageItemInventory getInventoryFor(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        if (owner == null) {
            throw new IllegalStateException("Stack has no owner!");
        }
        UUID invId = TieredPersonalStorageManager.getInventoryId(stack);
        Item item = stack.m_41720_();
        if (!(item instanceof ItemBlockTieredPersonalStorage)) {
            throw new IllegalStateException("Item isn't ItemBlockTieredPersonalStorage");
        }
        ItemBlockTieredPersonalStorage item2 = (ItemBlockTieredPersonalStorage)item;
        TieredPersonalStorageItemInventory storageItemInventory = TieredPersonalStorageManager.forOwner(owner).getOrAddInventory(invId, item2.getTier());
        ListTag legacyData = ItemDataUtils.getList((ItemStack)stack, (String)"Items");
        if (!legacyData.isEmpty()) {
            DataHandlerUtils.readContainers(storageItemInventory.getInventorySlots(null), (ListTag)legacyData);
            ItemDataUtils.removeData((ItemStack)stack, (String)"Items");
        }
        return storageItemInventory;
    }

    public static Optional<TieredPersonalStorageItemInventory> getInventoryIfPresent(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        UUID invId = TieredPersonalStorageManager.getInventoryIdNullable(stack);
        boolean hasLegacyData = ItemDataUtils.hasData((ItemStack)stack, (String)"Items", (int)9);
        return Optional.ofNullable(owner != null && (invId != null || hasLegacyData) ? TieredPersonalStorageManager.getInventoryFor(stack) : null);
    }

    public static void deleteInventory(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        UUID invId = TieredPersonalStorageManager.getInventoryIdNullable(stack);
        if (owner != null && invId != null) {
            TieredPersonalStorageManager.forOwner(owner).removeInventory(invId);
        }
    }

    @NotNull
    private static UUID getInventoryId(ItemStack stack) {
        UUID invId = TieredPersonalStorageManager.getInventoryIdNullable(stack);
        if (invId == null) {
            invId = UUID.randomUUID();
            ItemDataUtils.setUUID((ItemStack)stack, (String)"personalStorageId", (UUID)invId);
        }
        return invId;
    }

    @Nullable
    private static UUID getInventoryIdNullable(ItemStack stack) {
        return ItemDataUtils.getUniqueID((ItemStack)stack, (String)"personalStorageId");
    }

    public static void reset() {
        STORAGE_BY_PLAYER_UUID.clear();
    }

    public static void createSlots(Consumer<IInventorySlot> slotConsumer, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInteract, IContentsListener listener, PersonalStorageTier tier) {
        for (int slotY = 0; slotY < tier.rows; ++slotY) {
            for (int slotX = 0; slotX < tier.columns; ++slotX) {
                slotConsumer.accept((IInventorySlot)BasicInventorySlot.at(canInteract, canInteract, (IContentsListener)listener, (int)(8 + slotX * 18), (int)(18 + slotY * 18)));
            }
        }
    }

    public static void transferFromBasic(AbstractPersonalStorageItemInventory oldInventory, ItemStack stack) {
        TieredPersonalStorageItemInventory inventory = TieredPersonalStorageManager.getInventoryFor(stack);
        for (int i = 0; i < oldInventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, oldInventory.getStackInSlot(i));
        }
    }

    public static void transferToNew(ItemStack oldItem, ItemStack stack) {
        TieredPersonalStorageItemInventory oldInventory = TieredPersonalStorageManager.getInventoryFor(oldItem);
        TieredPersonalStorageItemInventory inventory = TieredPersonalStorageManager.getInventoryFor(stack);
        for (int i = 0; i < oldInventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, oldInventory.getStackInSlot(i));
        }
    }
}

